unit Vect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TVect=record
  x,y,z       : real;
  end;

  TFormV = class(TForm)
    Label5: TLabel;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Edit3: TEdit;
    Label3: TLabel;
    Ok: TBitBtn;
    Cancel: TBitBtn;
    procedure Edit1Exit(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure ChancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn1Click(Sender: TObject);
    procedure CancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  FormV   : TFormV;
  Vec     : Tvect;
  vvv     : integer;

Procedure PrintVec;

implementation

uses PFak11;

{$R *.DFM}
Procedure PrintVec;
begin
  FormV.Edit1.Text:=RealToStr(Vec.x);
  FormV.Edit2.Text:=RealToStr(Vec.y);
  FormV.Edit3.Text:=RealToStr(Vec.z);
end;
{*****************************************}
procedure TFormV.Edit1Exit(Sender: TObject);
begin
  News(Vec.x,FormV.Edit1.text,False);
  PrintVec;
end;
procedure TFormV.Edit2Exit(Sender: TObject);
begin
  News(Vec.y,FormV.Edit2.text,False);
  PrintVec;
end;
procedure TFormV.Edit3Exit(Sender: TObject);
begin
  News(Vec.z,FormV.Edit3.text,False);
  PrintVec;
end;
procedure TFormV.OkClick(Sender: TObject);
begin
case vvv of
   1 : Nature.gVect:=Vec;
   2 : Nature.EVect:=Vec;
   3 : Nature.BVect:=Vec;
   4 : Begin
       with Item.Obj[Item.Turn_on] do
       begin
       VVect:=Vec;
       V:=sqrt(sqr(VVect.x)+sqr(VVect.y)+sqr(VVect.z));
       V_old:=V;
       end;
       end;
  else ShowMessage('Error vvv');
  end;
FormV.Visible:=False;
Main.Enabled:=True;
Save(0);
PFak11.Printt;
end;
procedure TFormV.ChancelClick(Sender: TObject);
begin
FormV.Visible:=False;
Main.Enabled:=True;
end;

procedure TFormV.FormClose(Sender: TObject; var Action: TCloseAction);
begin
FormV.Visible:=False;
Main.Enabled:=True;
end;

procedure TFormV.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if (Key in [#13]) then
     begin
       News(Vec.x,FormV.Edit1.text,False);
       PrintVec;
       FormV.Ok.SetFocus;
     end;
  If Not (Key in ['0','1','2','3',
                  '4','5','6','7',
                  '8','9','.',',','-',#8,#13])
     Then Key:=#27;
end;

procedure TFormV.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
  if (Key in [#13]) then
     begin
       News(Vec.y,FormV.Edit2.text,False);
       PrintVec;
       FormV.Ok.SetFocus;
     end;
If Not (Key in ['0','1','2','3',
                '4','5','6','7',
                '8','9','.',',','-',#8,#13])
  Then Key:=#27;
end;

procedure TFormV.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
  if (Key in [#13]) then
     begin
       News(Vec.z,FormV.Edit3.text,False);
       PrintVec;
       FormV.Ok.SetFocus;
     end;
If Not (Key in ['0','1','2','3',
                '4','5','6','7',
                '8','9','.',',','-',#8,#13])
  Then Key:=#27;
end;

procedure TFormV.BitBtn1Click(Sender: TObject);
begin
case vvv of
   1 : Nature.gVect:=Vec;
   2 : Nature.EVect:=Vec;
   3 : Nature.BVect:=Vec;
   4 : Begin Item.Obj[Item.Turn_on].VVect:=Vec;
       with Item.Obj[Item.Turn_on] do
       begin
       V:=sqrt(sqr(VVect.x)+sqr(VVect.y)+sqr(VVect.z));
       V_old:=V;
       end;
       end;
  else ShowMessage('Error vvv');
  end;
FormV.Visible:=False;
Main.Enabled:=True;
PFak11.Printt;
end;

procedure TFormV.CancelClick(Sender: TObject);
begin
FormV.Visible:=False;
Main.Enabled:=True;
end;

end.
